/*
 * Decompiled with CFR 0.152.
 */
package emulator.util;

import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.util.TickWorker;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TickThread
extends Thread {
    private List<TickWorker> workerList = new LinkedList<TickWorker>();
    private ClockHandle clock;

    public TickThread(Clock clock) {
        if (clock != null) {
            this.clock = clock.acquireHandle();
        }
    }

    public void addTickWorker(TickWorker tickWorker) {
        this.workerList.add(tickWorker);
        tickWorker.setClock(this.clock);
    }

    @Override
    public void run() {
        block0: while (true) {
            this.clock.tick();
            Iterator<TickWorker> iterator = this.workerList.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                TickWorker tickWorker = iterator.next();
                tickWorker.runTick();
            }
            break;
        }
    }
}

